% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{splitClonotypes}
\alias{splitClonotypes}
\alias{splitClonotypes,Matrix-method}
\alias{splitClonotypes,matrix-method}
\alias{splitClonotypes,SingleCellExperiment-method}
\alias{splitClonotypes,clonoStats-method}
\title{Split cell-level clonotype counts by sample}
\usage{
splitClonotypes(x, by, ...)

\S4method{splitClonotypes}{Matrix}(x, by)

\S4method{splitClonotypes}{matrix}(x, by)

\S4method{splitClonotypes}{SingleCellExperiment}(x, by, contigs = "contigs", clonoStats = "clonoStats")

\S4method{splitClonotypes}{clonoStats}(x, by)
}
\arguments{
\item{x}{A \code{Matrix} of cell-level clonotype assignments
(cells-by-clonotypes) or a \code{SingleCellExperiment} object with such a
matrix stored in the \code{clono} slot of the \code{colData}.}

\item{by}{A character vector or factor by which to split the clonotype
counts. If \code{x} is a \code{SingleCellExperiment} object, this can also
be a character, giving the name of the column from the \code{colData} to
use as this variable. Similar to the \code{group} argument for
\code{\link{clonoStats}}.}

\item{...}{additional arguments.}

\item{contigs}{character. If \code{x} is a \code{SingleCellExperiment}, the
name of the \code{SplitDataFrameList} in the \code{colData} of \code{x}
containing contig information.}

\item{clonoStats}{character. If \code{x} is a \code{SingleCellExperiment},
the name of the element in the \code{metadata} of \code{x} that contains
the output of \code{clonoStats}. Must include cell-level clonotype
assignments (ie. \code{assignment = TRUE}).}
}
\value{
A list of \code{Matrix} objects providing the cell-level clonotype
assignments for each unique value of \code{by} (if \code{by} denotes sample
labels, each matrix in the list will contain the cells from a single
sample).
}
\description{
Takes a matrix of cell-level clonotype counts and splits them
into a list of group-specific counts (typically samples).
}
\examples{
example(addVDJtoSCE)
x <- clonoStats(contigs, assignment = TRUE)
splitClonotypes(x, by = sce$sample)

}
