% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pieVDJ.R
\name{pieVDJ}
\alias{pieVDJ}
\alias{pieVDJ,Matrix-method}
\alias{pieVDJ,matrix-method}
\alias{pieVDJ,clonoStats-method}
\title{Create a pie chart for clonotype expansion}
\usage{
pieVDJ(x, ...)

\S4method{pieVDJ}{Matrix}(x, legend = "bottom")

\S4method{pieVDJ}{matrix}(x, ...)

\S4method{pieVDJ}{clonoStats}(x, ...)
}
\arguments{
\item{x}{A \code{matrix} created with \code{summarizeClonotypes}.}

\item{...}{additional arguments.}

\item{legend}{Can take on the values use in the legend.position command
in ggplot ("left","top", "right", "bottom", or a numeric vector) to
indicate where the legend should be placed. If left NULL, no legend will
be created.}
}
\value{
If \code{x} contains more than one sample, a list of pie charts
will be returned. If \code{x} contains only one sample, the pie chart
will be returned. The coloring indicates the number of cells
for each clonotype with darker colors being clonotypes with a single cell
(singletons) and lighter colors having more cells with that clonotype
(expanded clonotype).
}
\description{
\code{pieVDJ} creates a list of pie charts created using ggplot
that shows the the level of expansion in each clonotype.
}
\examples{
data('contigs')
x <- clonoStats(contigs)
pieVDJ(x)

}
