% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contactsUMI4C.R
\name{alignmentUMI4C}
\alias{alignmentUMI4C}
\title{UMI4C alignment}
\usage{
alignmentUMI4C(
  wk_dir,
  pos_viewpoint,
  bowtie_index,
  threads = 1,
  filter_bp = 1e+07
)
}
\arguments{
\item{wk_dir}{Working directory where to save the outputs generated by the
UMI-4c analysis.}

\item{pos_viewpoint}{GRanges object containing the genomic position of the
viewpoint. It can be generated by \code{getViewpointCoordinates} function.}

\item{bowtie_index}{Path and prefix of the bowtie index to use for the
alignment.}

\item{threads}{Number of threads to use in the analysis. Default=1.}

\item{filter_bp}{Integer indicating the bp upstream and downstream of the
viewpoint to select for further analysis. Default=10e6}
}
\value{
Creates a BAM file in \code{wk_dir/align} named
"\code{basename(fastq))_filtered.bam}", containing the
aligned filtered reads. The alignment log is also generated in
\code{wk_dir/logs} named "\code{umi4c_alignment_stats.txt}".
}
\description{
Align split UMI-4C reads to a reference genome using Bowtie2.
}
\examples{
if (interactive()){
path <- downloadUMI4CexampleData(reduced = TRUE)
alignmentUMI4C(
    wk_dir = file.path(path, "CIITA"),
    pos_viewpoint = GenomicRanges::GRanges("chr16:10972515-10972548"),
    bowtie_index = file.path(path, "ref_genome", "ucsc.hg19.chr16")
)
}
}
