% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{results}
\alias{results}
\title{results}
\usage{
results(DATA, type = c("TrendyFits"))
}
\arguments{
\item{DATA}{An object of class \code{SummarizedExperiment} that contains 
normalized expression and other metadata, and the output of the
\code{Trendy} function.}

\item{type}{A character variable specifying which output is desired, 
with possible values "TrendyFits".
By default results() will
return type="TrendyFits", which is the matrix of normalized 
counts from SCnorm.}
}
\value{
A \code{data.frame} containing output as detailed in the
 description of the \code{type} input parameter
}
\description{
Convenient helper function to extract the results of running 
Trendy. Results data.frames/matrices are stored in the 
\code{metadata} slot and can also be accessed without the help of this 
convenience function by calling \code{metadata()}.
}
\examples{
 data(trendyExampleData)
 Conditions = rep(c(1), each= 90)
 trendyOut <- trendy(Data=trendyExampleData[seq_len(2),])
 trendyResults <- results(trendyOut)
}
