% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breakpointDist.R
\name{breakpointDist}
\alias{breakpointDist}
\title{Distribution of breakpoints}
\usage{
breakpointDist(topTrendyData, NDigits = 0)
}
\arguments{
\item{topTrendyData}{results from topTrendy() function}

\item{NDigits}{how many digits to be used when rounding 
(default is 0 (return integers))}
}
\value{
The function takes significant genes called from 
the topTrendyData() function. For any time point, this 
function calculates how many genes
have a breakpoint at this time point. The output is the
numbers of genes sorted by time point.
}
\description{
calculates number of breakpoints at each time.
}
\examples{
 m1 <- matrix(c(c(rnorm(50,5,1),sort(rnorm(50, 15, 5))), rnorm(100, 50,10)), 2, 100, TRUE)
 rownames(m1) <- c("g1","g2")
 colnames(m1) <- paste0("time", seq_len(100))
 myTrends <- results(trendy(m1))
 topGenes <- topTrendy(myTrends)
 bpDist <- breakpointDist(topGenes)
}
\author{
Ning Leng
}
