% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecate_Fun.R, R/tree_joinNode.R
\name{signalNode}
\alias{signalNode}
\alias{joinNode}
\title{Join nodes}
\usage{
signalNode(tree, node, use.alias = FALSE)

joinNode(tree, node, use.alias = FALSE)
}
\arguments{
\item{tree}{A tree (phylo object)}

\item{node}{A vector of node numbers or node labels}

\item{use.alias}{A logical value, TRUE or FALSE. The default is FALSE, and
the node label would be used to name the output; otherwise, the alias of
node label would be used to name the output. The alias of node label is
created by adding a prefix \code{"alias_"} to the node number.}
}
\value{
A vector of nodes. The numeric value is the node number, and the
  vector name is the corresponding node label. If a node has no label, it
  would have NA as name when \code{use.alias = FALSE}, and have the alias of
  node label as name when \code{use.alias = TRUE}.
}
\description{
\code{joinNode} is to use as few as possible nodes to represent the provided
nodes so that descendant leaves covered by the input nodes and output nodes
are exactly the same.
}
\examples{

data(tinyTree)
library(ggtree)

# PLOT tree
# The node labels are in orange texts and the node numbers are in blue
ggtree(tinyTree,branch.length = 'none')+
    geom_text2(aes(label = label), color = "darkorange",
           hjust = -0.1, vjust = -0.7) +
    geom_text2(aes(label = node), color = "darkblue",
               hjust = -0.5, vjust = 0.7)

## find the node shared by provided node labels
joinNode(node = c('t4','t9'), tree = tinyTree)
joinNode(node = c('t4','t9'), tree = tinyTree)
joinNode(node = c('t10','Node_18', 't8'), 
         tree = tinyTree,
         use.alias = FALSE)
joinNode(node = c('t10','Node_18', 't8'), 
         tree = tinyTree,
         use.alias = TRUE)

## find the node shared by provided node numbers
joinNode(node = c(2, 3), tree = tinyTree)
joinNode(node = c(2, 3, 16), tree = tinyTree)

}
\author{
Ruizhu Huang
}
