% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeAndLeaf.R
\name{treeAndLeaf}
\alias{treeAndLeaf}
\title{Layout a TreeAndLeaf diagram.}
\usage{
treeAndLeaf(obj)
}
\arguments{
\item{obj}{An object of class 'hclust' or 'phylo'.}
}
\value{
A tree-and-leaf igraph object.
}
\description{
This function tranforms hclust and phylo objects into tree-and-leaf 
igraph objects.
}
\examples{
library(RedeR)
rdp <- RedPort()
hc <- hclust(dist(USArrests), "ave")
tal <- treeAndLeaf(hc)

\dontrun{
calld(rdp)
addGraph(obj=rdp, tal)
}

}
\seealso{
\code{\link{formatTree}}

\code{\link[stats:hclust]{hclust}}

\code{\link[ape:as.phylo]{as.phylo}}

\code{\link[RedeR:addGraph]{addGraph}}

\code{\link[RedeR:relax]{relax}}
}
