% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatTree.R
\name{formatTree}
\alias{formatTree}
\title{A theme function for tree-and-leaf igraph objects.}
\usage{
formatTree(tal, theme = 1)
}
\arguments{
\item{tal}{An igraph object generated by the \code{\link{TreeAndLeaf}} function.}

\item{theme}{An integer ranging from 1 to 5 with desired theme. \cr
Options: \cr
1- A clean black and blue theme, for additional customizations. \cr
2- Green palette theme. \cr
3- Blue palette theme. \cr
4- Purple palette theme. \cr
5- Red palette theme. \cr
For detailed customization, see attributes in the 
\code{\link[RedeR]{addGraph}} method. \cr}
}
\value{
An igraph object with attributes for RedeR application.
}
\description{
This function sets attributes of a tree-and-leaf igraph object for
plotting in the RedeR app interface.
}
\examples{
library(RedeR)
hc <- hclust(dist(USArrests), "ave")
tal <- treeAndLeaf(hc)
tal <- formatTree(tal, theme = 5)

}
\seealso{
\code{\link[RedeR]{addGraph}}

\code{\link{treeAndLeaf}}
}
