% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrajectoryGeometry.R
\name{getDistanceDataForPaths}
\alias{getDistanceDataForPaths}
\title{Produce distance statistics for random paths}
\usage{
getDistanceDataForPaths(paths, statistic)
}
\arguments{
\item{paths}{- A list of paths.  Each of these is an n x d matrix.}

\item{statistic}{- Allowable values are 'median', 'mean' or 'max'.}
}
\value{
This returns a vector of n distances.
}
\description{
This function takes a list of paths and a choice of
statistic (median, mean or max) and returns that statistic
for the appropriate center for each path.  Each path
is an n x d matrix.  In use, it is assumed that these
will be the randomized paths.  It is therefore assumed
that they are already of the correct dimensions.
}
\examples{
paths =
    generateRandomPaths(path=straight_path,randomizationParam='bySteps',N=5)
distance = getDistanceDataForPaths(paths=paths,statistic='max')
}
