% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tntTracks.R
\name{trackdata}
\alias{trackdata}
\alias{trackData}
\alias{trackData<-}
\alias{$,TnTTrack-method}
\alias{$<-,TnTTrack-method}
\title{Access Track Data}
\usage{
trackData(x)

trackData(x) <- value

\S4method{$}{TnTTrack}(x, name)

\S4method{$}{TnTTrack}(x, name) <- value
}
\arguments{
\item{x}{A TnTTrack object.}

\item{value}{Replaced value.}

\item{name}{Passed to the inner method for track data.}
}
\value{
\code{trackData} on all track types except "CompositeTrack" returns an
    object that inherits GRanges class, which means they should behave like a GRanges.
    While \code{trackData} on "CompositeTrack" returns a list of tracks.
}
\description{
Access and modify the track data. \code{x$name} and \code{x$name <- value} are
just shortcuts for \code{trackData(x)$name} and \code{trackData(x)$name <- value},
respectively.
}
\examples{
track <- BlockTrack(GRanges("chr1", IRanges(6, 54)))
class(trackData(track)) # track data of block track is an object that inherits GRanges.
#trackData(track)
ctrack <- merge(track, track)
class(trackData(ctrack)) # track data of composite track is a list of tracks
#trackData(ctrack)
}
