% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tntTracks-constructors.R
\name{track-constructors}
\alias{track-constructors}
\alias{BlockTrack}
\alias{VlineTrack}
\alias{PinTrack}
\alias{LineTrack}
\alias{AreaTrack}
\alias{GeneTrackFromTxDb}
\alias{FeatureTrack}
\alias{GroupFeatureTrack}
\alias{TxTrackFromTxDb}
\alias{TxTrackFromGRanges}
\title{Track Constructors}
\usage{
BlockTrack(
  range,
  label = deparse(substitute(range)),
  tooltip = mcols(range),
  color = "blue",
  background = NULL,
  height = 30
)

VlineTrack(
  pos,
  label = deparse(substitute(pos)),
  tooltip = mcols(pos),
  color = "green",
  background = NULL,
  height = 40
)

PinTrack(
  pos,
  value = mcols(pos)$value,
  domain = numeric(),
  label = deparse(substitute(pos)),
  tooltip = mcols(pos),
  color = "red",
  background = NULL,
  height = 40
)

LineTrack(
  pos,
  value = mcols(pos)$value,
  domain = numeric(),
  label = deparse(substitute(pos)),
  color = "yellow",
  background = NULL,
  height = 70
)

AreaTrack(
  pos,
  value = mcols(pos)$value,
  domain = numeric(),
  label = deparse(substitute(pos)),
  color = "pink",
  background = NULL,
  height = 70
)

GeneTrackFromTxDb(
  txdb,
  seqlevel = seqlevels(txdb),
  label = deparse(substitute(txdb)),
  color = "black",
  background = NULL,
  height = 100
)

FeatureTrack(
  range,
  label = deparse(substitute(range)),
  tooltip = mcols(range),
  names = base::names(range),
  color = "black",
  background = NULL,
  height = 200
)

GroupFeatureTrack(
  grl,
  label = deparse(substitute(grl)),
  tooltip = mcols(grl),
  names = base::names(grl),
  color = "black",
  background = NULL,
  height = 200
)

TxTrackFromTxDb(
  txdb,
  seqlevel = seqlevels(txdb),
  label = deparse(substitute(txdb)),
  color = "red",
  background = NULL,
  height = 300
)

TxTrackFromGRanges(
  gr,
  label = deparse(substitute(gr)),
  color = "red",
  background = NULL,
  height = 300
)
}
\arguments{
\item{range, pos}{GRanges or IRanges object. For pos, all the width should be one.}

\item{label}{Character, shown as label of the track on the left, could be NULL.}

\item{tooltip}{A data frame that is parallel to range or pos.}

\item{color}{Character vector or integer vector that sets the color of the features.
It can be color names, hexadecimal string or positive integer \code{i} meaning
\code{\link{palette}()[i]}, as described in \code{\link[grDevices]{col2rgb}}.
It can be parallel to the data (i.e. have the same length) thus sets colors
of each individual feature.}

\item{background}{Length-one character vector that sets background of the track,
could be NULL.}

\item{height}{Length-one numeric vector that sets height of the track.}

\item{value, domain}{`value` is a numeric vector that is parallel to pos, which indicates
height of features at each position for PinTrack, LineTrack and AreaTrack. `domain` is
a length-two numeric vector which sets the lower and upper limit of `value` (i.e. the limit on y-axis).}

\item{txdb, seqlevel}{The TxDb and seqlevel to extract gene or transcript from.}

\item{names}{Character vector with the same length of data, which is used to generate display labels
shown together with features when zooming in.}

\item{grl}{For `GroupFeatureTrack` function, a GRangesList object that represents grouped ranges
as data source. It is assumed that ranges in each group are on the same strand and do not overlap.}

\item{gr}{For `TxTrackFromGRanges` function, a GRanges object that represents exons and cds as data
source, and will be rendered as transcripts. Two meta-columns ("type", "tx_id") are required,
"type" can be "exon" or "cds" by which ranges of "cds" will be filled with color, "tx_id" indicates
the grouping.}
}
\value{
Returns an object that extends "TnTTrack" class.
}
\description{
Track Constructors
}
\examples{
BlockTrack(range = GRanges("chr1", IRanges(199, 4000)),
           color = "green", background = "red", height = 100)
}
\seealso{
You can find various examples at \url{http://tnt.marlin.pub/articles/examples/},
    also see \code{\link{composite-track}} on how to create a composite track.
}
