% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teEnrichment.R
\name{teEnrichment}
\alias{teEnrichment}
\title{Calculate tissue-specific gene enrichment using the hypergeometric test}
\usage{
teEnrichment(
  inputGenes = NULL,
  rnaSeqDataset = 1,
  tissueSpecificGeneType = 1,
  multiHypoCorrection = TRUE,
  backgroundGenes = NULL
)
}
\arguments{
\item{inputGenes}{A GeneSet object containing the input genes, organism type
('Homo Sapiens' or 'Mus Musculus'), and gene id identifier (Gene Symbol or
ENSEMBL identifier).}

\item{rnaSeqDataset}{An integer describing the dataset to be used for
enrichment analysis. 1 for 'Human Protein Atlas' (default), 2 for 'GTEx',
3 for 'Mouse ENCODE'. Default 1.}

\item{tissueSpecificGeneType}{An integer describing the type of tissue-
specific genes to be used. 1 for 'All' (default), 2 for 'Tissue-Enriched',
 3 for 'Tissue-Enhanced', and 4 for 'Group-Enriched'. Default 1.}

\item{multiHypoCorrection}{Flag to correct P-values for multiple hypothesis
using BH method. Default TRUE.}

\item{backgroundGenes}{A GeneSet object containing the background gene
list, organism type ('Homo Sapiens' or 'Mus Musculus'), and gene id
identifier (Gene Symbol or ENSEMBL identifier). The input genes must
be present in the background gene list. If not provided all the genes
will be used as background.}
}
\value{
The output is a list with four objects. The first object is the
SummarizedExperiment object containing the enrichment results, the second
and the third object contains the expression values and tissue-specificity
information of the tissue-specific genes for genes from the input
gene set, and the fourth is a GeneSet object containing genes that
were not identified in the tissue-specific gene data.
}
\description{
The teEnrichment function is used to calculate the enrichment
of tissue-specific genes, given an input gene set. It uses tissue-specific
genes defined by processing RNA-Seq datasets from human and mouse.
}
\examples{
library(dplyr)
library(ggplot2)
genes<-system.file('extdata', 'inputGenes.txt', package = 'TissueEnrich')
inputGenes<-scan(genes,character())
gs<-GeneSet(geneIds=inputGenes,organism='Homo Sapiens',
geneIdType=SymbolIdentifier())
output<-teEnrichment(gs)
seEnrichmentOutput<-output[[1]]
enrichmentOutput<-setNames(data.frame(assay(seEnrichmentOutput),
row.names = rowData(seEnrichmentOutput)[,1]),
colData(seEnrichmentOutput)[,1])
enrichmentOutput$Tissue<-row.names(enrichmentOutput)
#Plotting the P-Values
ggplot(enrichmentOutput,aes(x=reorder(Tissue,-Log10PValue),y=Log10PValue,
label = Tissue.Specific.Genes,fill = Tissue))+
geom_bar(stat = 'identity')+
labs(x='', y = '-LOG10(P-Value)')+
theme_bw()+
theme(legend.position='none')+
theme(plot.title = element_text(hjust = 0.5,size = 20),axis.title =
element_text(size=15))+
theme(axis.text.x = element_text(angle = 45, vjust = 1, hjust = 1),
panel.grid.major= element_blank(),panel.grid.minor = element_blank())
}
\author{
Ashish Jain, Geetu Tuteja
}
