\name{NetCDFPeakFinding}
\alias{NetCDFPeakFinding}
\title{ Peak picking algorithm from CDF files }

\description{
	This function reads a netcdf chromatogram file, finds the apex intensities
	and returns a list containing the retention time and the intensity matrices.
}

\usage{
NetCDFPeakFinding(ncdf, massRange = NULL, Window = 15, IntThreshold = 10,
                  pp.method = "ppc", baseline = FALSE, ...)
}

\arguments{
  \item{ncdf}{A character string naming a netcdf file or a list generated by the function
	  \code{\link{peakCDFextraction}}.}
  \item{massRange}{Deprecated. It is completely ignored but it is kept for
                   compatibility with old scripts.}
  \item{Window}{The window used by peak picking method. The number of points actually used
                is \code{2*Window + 1}. }
  \item{IntThreshold}{Apex intensities lower than this value will be removed from the RI files. }
  \item{pp.method}{The pick picking method to be used. Options are \code{"smoothing"},
                   \code{"gaussian"} and \code{"ppc"}.}
  \item{baseline}{Logical. Should baseline correction be performed?}
  \item{\dots}{Extra options passed to \code{\link{baseline}}.}
}

\details{
	The parameter \code{ncdf} should be either a path to a NetCDF file or a list
	generated by the function \code{\link{peakCDFextraction}}. This list contains elements
	named "Time", "Peaks", "massRange", "Index", and "baselineCorrected". Refer to
	the function's man page for details.

	Formerly, the \code{massRange} parameter was a numeric vector with two components: lower
	and higher masses. Now, the mass range is detected automatically and it has no effect if
	it is set. It is kept only for compatibility reasons.

	There are three peak picking algorithms that can be used. The \code{"smoothing"} method
	smooths the m/z curves by a moving average and then looks for a change of sign of the
	intensity difference between two consecutive points. The \code{"gaussian"} is exactly
	the same, but it uses a gaussian smoother instead of a moving average.

	The \code{"ppc"} uses a sliding window and looks for the local maxima. This method is
	based on the R-package \code{ppc} (now unavailable).
}

\value{
  A three component list.
  \item{Time}{The retention time vector.}
  \item{Peaks}{The intensity matrix. Rows are the retention times and columns are masses. The first
               column is the lower mass value and the last one is the higher mass. }
  \item{massRange}{The mass range.}
}

\author{Alvaro Cuadros-Inostroza, Matthew Hannah, Henning Redestig }
\examples{
require(TargetSearchData)
# pick first CDF file
CDFfile <- tsd_cdffiles()[1]

# extract peaks of first chromatogram
peaks.1 <- NetCDFPeakFinding(CDFfile, Window = 15, IntThreshold = 10, pp.method = "ppc")
# scan acquisition times
head(peaks.1$Time)
# peaks in matrix form. first column is mass 85, last one is mass 320.
head(peaks.1$Peaks)

}
\seealso{ \code{\link{peakCDFextraction}} }
