% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoyScoreTable.R
\name{decoyScoreTable}
\alias{decoyScoreTable}
\title{Prepare score table for decoys}
\usage{
decoyScoreTable(object, decoy, score, log10 = TRUE)
}
\arguments{
\item{object}{A \code{data.frame}, \linkS4class{mzID} or \linkS4class{mzRident} object.}

\item{decoy}{\code{character}, name of the variable that indicates if the peptide
matches to a target or to a decoy. When this value is missing, a Shiny
gadget is launched to select it interactively.}

\item{score}{\code{numeric}, indicating the score of the peptide match, obtained
by the search engine. When this value is missing, a Shiny gadget is
launched to select it interactively.}

\item{log10}{\code{logical} to indicate if the score should be
\code{-log10}-transformed. Default: \code{TRUE}. When this value is missing, a Shiny
gadget is launched to select it interactively.}
}
\value{
A \code{data.frame} with a logical \code{"decoy"} column and numeric \code{"scores"}.
}
\description{
Takes an input object and returns a score table for the decoys.
}
\examples{
library(mzID)

## Use one of the example files in the mzID package
exampleFile <- system.file("extdata", "55merge_tandem.mzid", package = "mzID")
mzIDexample <- mzID(exampleFile)

decoyScoreTable(mzIDexample, decoy = "isdecoy", score = "x\\\\!tandem:expect")
}
\author{
Elke Debrie, Lieven Clement
}
