% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write_analysis.R
\name{read_tsar}
\alias{read_tsar}
\title{Read analysis result}
\usage{
read_tsar(gam_result, output_content)
}
\arguments{
\item{gam_result}{list; input uses resulting output of
\code{\link{gam_analysis}}() function}

\item{output_content}{integer;
\code{output_content = 0} returns only the tm value by wells
\code{output_content = 1} returns data table with fitted values
\code{output_content = 2} returns the combination of 0 and 1}
}
\value{
output files with select dataset
}
\description{
reads previous pipeline output lists from \code{\link{gam_analysis}}()
    and organizes them into separate data frames.
}
\examples{
data("qPCR_data1")
result <- gam_analysis(qPCR_data1,
    smoothed = TRUE, fluo_col = 5,
    selections = c(
        "Well.Position", "Temperature", "Fluorescence", "Normalized"
    )
)
read_tsar(result, output_content = 0)
output_data <- read_tsar(result, output_content = 2)

}
\seealso{
Other read_write_analysis: 
\code{\link{join_well_info}()},
\code{\link{write_tsar}()}
}
\concept{read_write_analysis}
