% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preprocess.R
\name{numerical_Tm}
\alias{numerical_Tm}
\title{Numerical Tm by treating Tm as inflection point}
\usage{
numerical_Tm(data, x, y)
}
\arguments{
\item{data}{data.frame with numeric columns x and y (specified by names).
Data will be sorted by x; duplicated x's are averaged.}

\item{x, y}{character; names of the predictor and response columns.}
}
\value{
Named numeric vector \code{c(x = x_Tm, y = y_Tm)}; \code{NA}s on failure.
}
\description{
Estimates the inflection point (Tm) as the (x, y) coordinate where the
discrete second derivative changes sign (zero-crossing). Among all
zero-crossings, chooses the one with the largest absolute first derivative
(steepest slope). Uses linear interpolation between adjacent points to refine
the zero of the second derivative.
}
\examples{
# tm_xy <- numerical_Tm(df, x = "Temperature", y = "Normalized")
}
