% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_to_tsar.R
\name{merge_norm}
\alias{merge_norm}
\title{Merge and format norm_data into tsar_data}
\usage{
merge_norm(data, name, date)
}
\arguments{
\item{data}{list, a character vector specifying the file paths of the data
files or data frame objects of analysis data set. For example, given data
frames named "data1" and "data2", specify parameter as
\code{data = list(data1, data2)}.}

\item{name}{list, character vector specifying the experiment names.}

\item{date}{list, character vector specifying the dates. Does not require
any date format restrictions.}
}
\value{
data frame in the format of tsar_data
}
\description{
This function merges data of experiment replicates across different dates.
    It merges and produces information variables used to group wells of same
    set up.
}
\details{
This function merges and normalizes test data from multiple files.
    The lengths of the \code{data}, \code{name}, and \code{date} vectors
    must match, otherwise an error is thrown.
}
\examples{
data("qPCR_data1")
result <- gam_analysis(qPCR_data1, smoothed = TRUE, fluo = 5)
data("well_information")
norm_data <- join_well_info(
    file_path = NULL, file = well_information,
    read_tsar(result, output_content = 2), type = "by_template"
)
norm_data <- na.omit(norm_data)
data("qPCR_data2")
result2 <- gam_analysis(qPCR_data1, smoothed = TRUE, fluo = 5)
norm_data2 <- join_well_info(
    file_path = NULL, file = well_information,
    read_tsar(result2, output_content = 2), type = "by_template"
)
norm_data2 <- na.omit(norm_data2)
tsar_data <- merge_norm(
    data = list(norm_data, norm_data2),
    name = c("Thermal Shift_162.eds.csv", "Thermal Shift_168.eds.csv"),
    date = c("20230203", "20230209")
)

}
\seealso{
Other TSAR Formatting: 
\code{\link{TSA_Tms}()},
\code{\link{TSA_average}()},
\code{\link{Tm_difference}()},
\code{\link{merge_TSA}()},
\code{\link{normalize_fluorescence}()},
\code{\link{rescale}()}
}
\concept{TSAR Formatting}
