% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLegend.R
\name{get_legend}
\alias{get_legend}
\title{Extract ggplot2 legend}
\usage{
get_legend(input_plot)
}
\arguments{
\item{input_plot}{a ggplot2 object}
}
\value{
two ggplots, one containing the legend and another containing
  all else.
}
\description{
Function enables separation of legends from plots within the TSAR package.
}
\examples{
data("example_tsar_data")
boxplot <- TSA_boxplot(example_tsar_data,
    color_by = "Protein",
    label_by = "Ligand", separate_legend = FALSE
)
get_legend(boxplot)

}
\seealso{
Other TSA Plots: 
\code{\link{TSA_boxplot}()},
\code{\link{TSA_compare_plot}()},
\code{\link{TSA_wells_plot}()},
\code{\link{graph_tsar}()},
\code{\link{view_deriv}()}
}
\concept{TSA Plots}
