% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsa_analysis.R
\name{gam_analysis}
\alias{gam_analysis}
\title{Analysis of all 96 wells through gam modeling}
\usage{
gam_analysis(
  raw_data,
  keep = TRUE,
  fit = FALSE,
  smoothed = FALSE,
  boltzmann = FALSE,
  fluo_col = NA,
  selections = c("Well.Position", "Temperature", "Fluorescence", "Normalized")
)
}
\arguments{
\item{raw_data}{data frame; raw data frame}

\item{keep}{Boolean; set to \code{keep = TRUE}
by default to return normalized data and fitted data}

\item{fit}{Boolean; set to \code{fit = FALSE} by default, \code{fit = TRUE}
returns access to information of each model fit. Not accessible in shiny.}

\item{smoothed}{Boolean; set to \code{smoothed = FALSE} by default,
if data is already smoothed, set smoothed to true}

\item{boltzmann}{Boolean; set to \code{boltzmann = FALSE} by default. Set
to \code{boltzmann = TRUE} if a botlzmann fit is preferred.}

\item{fluo_col}{integer; the Fluorescence variable column id
(e.g. fluo = 5 when 5th column of data frame is the Fluorescence value)
if fluorescence variable is named exactly as "Fluorescence", fluo does
not need to be specified.}

\item{selections}{list of characters; the variables in raw data user intends
to keep. It is set, by default, to \code{c("Well.Position",
"Temperature", "Fluorescence", "Normalized")}.}
}
\value{
List of data frames, list of three data frame outputs,
    Tm estimation by well, data set, fit of model by well.
}
\description{
Function pipeline that combines separated functions and iterate through
    each well to estimate the Tm.
}
\examples{
data("qPCR_data1")
gam_analysis(qPCR_data1,
    smoothed = TRUE, boltzmann = FALSE, fluo_col = 5,
    selections = c(
        "Well.Position", "Temperature", "Fluorescence",
        "Normalized"
    )
)
model <- gam_analysis(qPCR_data1, smoothed = FALSE, boltzmann = TRUE)

}
\seealso{
Other tsa_analysis: 
\code{\link{Tm_est}()}
}
\concept{tsa_analysis}
