% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tm_Diff.R
\name{Tm_difference}
\alias{Tm_difference}
\title{Calculate Tm difference for all conditions}
\usage{
Tm_difference(tsa_data, control_condition)
}
\arguments{
\item{tsa_data}{a data frame that is merged and generated by
TSAR::merge_TSA(). If \code{y = 'RFU'}, tsa_data must also be
generated by TSAR::normalize_fluorescence. The Temperature column will be
rounded and the average & sd of each rounded temperature is calculated.}

\item{control_condition}{character string matching a Condition ID. Must be
equal to a value within tsa_data$condition_ID. See unique condition IDs
with \code{\link{condition_IDs}}.}
}
\value{
a data frame of reformatted data with the \code{\link{TSA_average}}
    data and the Tm.
}
\description{
From a specified control condition, the change in Tm is calculated for
    each condition in the tsa_data. Specifically,
    \eqn{Tm = condition - control}. Individual Tm values are averaged by
    condition, see \code{\link{TSA_average}} for details.
    To see all conditions use \code{condition_IDs(tsa_data)}.
}
\examples{
data("example_tsar_data")
control <- condition_IDs(example_tsar_data)[1]
Tm_difference(example_tsar_data, control_condition = control)

}
\seealso{
\code{\link{merge_TSA}} for preparing data.
    \code{\link{TSA_average}} for more information on the output data.
    \code{\link{condition_IDs}} to get unique Condition IDs within the
    input.
    \code{\link{TSA_boxplot}} for application.

Other TSAR Formatting: 
\code{\link{TSA_Tms}()},
\code{\link{TSA_average}()},
\code{\link{merge_TSA}()},
\code{\link{merge_norm}()},
\code{\link{normalize_fluorescence}()},
\code{\link{rescale}()}
}
\concept{TSAR Formatting}
