% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsa_curves.R
\name{TSA_wells_plot}
\alias{TSA_wells_plot}
\title{TSA Well Curves Plot}
\usage{
TSA_wells_plot(
  tsa_data,
  y = "RFU",
  show_Tm = TRUE,
  Tm_label_nudge = 7.5,
  show_average = TRUE,
  plot_title = NA,
  plot_subtitle = NA,
  smooth = TRUE,
  separate_legend = TRUE,
  smoother = c("gam", "beta", "none"),
  beta_shape = 3,
  beta_n_knots = NULL,
  beta_knots_frac = 0.12,
  use_natural = TRUE
)
}
\arguments{
\item{tsa_data}{a data frame that is merged and generated by
TSAR::merge_TSA(). If \code{y = 'RFU'}, tsa_data must also be
generated by TSAR::normalize_fluorescence. The Temperature column will be
rounded and the average & sd of each rounded temperature is calculated.}

\item{y}{character string; c('Fluorescence', 'RFU').
When \code{y = 'Fluorescence'}, the original Fluorescence data from
TSAR::read_raw_data() is averaged. When \code{y = 'RFU'}, the average is
calculated by the rescaled fluorescence.}

\item{show_Tm}{logical; \code{show_Tm = TRUE} by default. When TRUE, the Tm
is displayed on the plot. When FALSE, the Tm is not added to the plot.}

\item{Tm_label_nudge}{numeric; \code{Tm_label_nudge = 7.5} the direction
in the x direction to move the Tm label. This is used prevent the label
from covering data. Ignored if \code{show_Tm = FALSE}.}

\item{show_average}{logical; \code{show_average = TRUE} by default.
When TRUE, the average is and sd is plotted as
generated by \code{\link{merge_TSA}}.}

\item{plot_title, plot_subtitle}{characer string, NA by default.
User-specified plots to overright automatic naming.}

\item{smooth}{logical; \code{smooth = TRUE} by default. When TRUE, linear
regression by \code{\link[mgcv]{gam}} is used to make clean lines on
the plot. See \code{\link{TSA_average}} for more details. When FALSE,
individual points are plotted (slows down rendering).}

\item{separate_legend}{logical; \code{separate_legend = TRUE} by default.
When TRUE, the ggplot2 legend is separated from the TSA curve.
This is to help with readability. One ggplot is returned when FALSE.}

\item{smoother}{character; one of \code{c("gam","beta","none")}.
Passed to \code{\link{TSA_average}} to select the aggregate smoother:
\code{"gam"} uses \pkg{mgcv}, \code{"beta"} uses a natural cubic spline
with Beta(a,a) interior knots centered at Tm, and \code{"none"} uses the
unsmoothed average. Default follows \code{TSA_average}.}

\item{beta_shape}{numeric; shape parameter \eqn{a} for the Beta(a,a) knot
placement when \code{smoother = "beta"}. \code{beta_shape = 3} by default. Passed to \code{TSA_average}.}

\item{beta_n_knots}{integer or \code{NULL}; number of interior knots when
\code{smoother = "beta"}. If \code{NULL}, uses \code{beta_knots_frac}.
Passed to \code{TSA_average}.}

\item{beta_knots_frac}{numeric in (0,1); fraction of unique temperatures used
as interior knots when \code{smoother = "beta"} and \code{beta_n_knots}
is \code{NULL}. \code{beta_knots_frac = 0.008} by default. Passed to \code{TSA_average}.}

\item{use_natural}{logical; if TRUE (default) uses natural cubic spline
basis for the beta method. Passed to \code{TSA_average}.}
}
\value{
By default, two ggplots are returned: one TSA curve and one legend
    key (when \code{separate_legend = TRUE}). When
    \code{separate_legend = FALSE}, a single ggplot is returned.
}
\description{
Generates the individual curves for each well in the merged tsa data input.
    Options to create an average and standard deviation sd of the plot
    in addition to the individual curves. The average and sd will be
    smoothened by linear regression; see \code{\link{TSA_average}} for
    details.
}
\examples{
data("example_tsar_data")
check <- subset(example_tsar_data, condition_ID == "CA FL_PyxINE HCl")
TSA_wells_plot(check, y = "Fluorescence", smooth = TRUE, separate_legend = TRUE,
               smoother = "beta", beta_shape = 4, beta_knots_frac = 0.008)

}
\seealso{
\code{\link{merge_TSA}} and \code{\link{normalize_fluorescence}}
    for preparing data. See \code{\link{TSA_average}} and
    \code{\link{get_legend}} for details on function parameters.

Other TSA Plots: 
\code{\link{TSA_boxplot}()},
\code{\link{TSA_compare_plot}()},
\code{\link{get_legend}()},
\code{\link{graph_tsar}()},
\code{\link{view_deriv}()}
}
\concept{TSA Plots}
