% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/averageTSA.R
\name{TSA_smoother_diagnostics}
\alias{TSA_smoother_diagnostics}
\title{Diagnose Smoother Accuracy Across Conditions}
\usage{
TSA_smoother_diagnostics(
  tsa_data,
  y = c("Fluorescence", "RFU"),
  metric = c("L2", "L1", "R2"),
  beta_shapes = NULL,
  beta_fracs = NULL,
  digits = 1,
  use_natural = TRUE,
  beta_n_knots = NULL
)
}
\arguments{
\item{tsa_data}{a data frame that is merged and generated by
TSAR::merge_TSA(). If \code{y = 'RFU'}, tsa_data must also be
generated by TSAR::normalize_fluorescence. The Temperature column will be
rounded and the average & sd of each rounded temperature is calculated.}

\item{y}{character string; c('Fluorescence', 'RFU').
When \code{y = 'Fluorescence'}, the original Fluorescence data from
TSAR::read_raw_data() is averaged. When \code{y = 'RFU'}, the average is
calculated by the rescaled fluorescence.}

\item{metric}{character; one of \code{c("L2","L1","R2")} with default
\code{"L2"}. Defines the accuracy metric between \code{average} (truth) and
\code{avg_smooth} (fit):
\itemize{
  \item \code{"L1"}: mean absolute error (MAE)
  \item \code{"L2"}: root mean squared error (RMSE)
  \item \code{"R2"}: coefficient of determination; higher is better
}}

\item{beta_shapes}{numeric vector or \code{NULL}; shapes \eqn{a} for the
Beta(a,a) knot placement when evaluating the \code{"beta"} smoother.
\strong{Default behavior:} if \code{NULL} or length 0, uses a single value
\code{4}.}

\item{beta_fracs}{numeric vector or \code{NULL}; fractions in \eqn{(0,1)}
giving the proportion of unique temperatures used as interior knots for the
\code{"beta"} smoother. \strong{Default behavior:} if \code{NULL} or length
0, uses a single value \code{0.008}.}

\item{digits}{integer; rounding applied to the Temperature grid before
aggregation. Default \code{1}. Passed to \code{\link{TSA_average}}.}

\item{use_natural}{logical; if \code{TRUE} (default) uses natural cubic spline
basis for the beta method. Passed to \code{\link{TSA_average}}.}

\item{beta_n_knots}{integer or \code{NULL}; number of interior knots for the
\code{"beta"} smoother. If \code{NULL} (default), the number of knots is
determined by \code{beta_knots_frac}. Passed through to
\code{\link{TSA_average}}.}
}
\value{
(Invisibly) a \code{data.frame} with columns:
\itemize{
  \item \code{condition_id}: condition label,
  \item \code{method}: \code{"gam"} or \code{beta(a=..., frac=...)} string,
  \item \code{error}: numeric value of the requested metric.
}
The function also prints a short textual summary to the console.
}
\description{
Computes per-condition fitting error for \code{gam} and \code{beta} smoothers
(as implemented in \code{\link{TSA_average}}) against the aggregated mean
curve. For each \code{condition_ID}, the function compares the smoothed mean
(\code{avg_smooth}) to the real aggregated mean (\code{average}) at
each temperature and reports the error in corresponding metric.
}
\details{
By default, it evaluates:
\itemize{
  \item \strong{GAM}: \code{smoother = "gam"}
  \item \strong{Beta (single spec)}: \code{beta_shape = 4}, \code{beta_knots_frac = 0.008}
}
If you supply vectors to \code{beta_shapes} and/or \code{beta_fracs}, the
function evaluates \emph{all} combinations for the beta method.
}
\examples{
\dontrun{
normalized_tsa_df

result <- TSA_smoother_diagnostics(normalized_tsa_df, y = "RFU", metric = "L2")
as.data.frame(result)
}
}
\seealso{
\code{\link{TSA_average}} (smoother implementation),
  \code{\link{TSA_wells_plot}} (visualization of per-well and averaged curves).
}
\concept{Diagnostics}
