% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tronco.R
\name{tronco.chowliu}
\alias{tronco.chowliu}
\title{Tronco Chow Liu}
\usage{
tronco.chowliu(
  data,
  regularization = c("bic", "aic"),
  do.boot = TRUE,
  nboot = 100,
  pvalue = 0.05,
  min.boot = 3,
  min.stat = TRUE,
  boot.seed = NULL,
  silent = FALSE,
  epos = 0,
  eneg = 0
)
}
\arguments{
\item{data}{A TRONCO compliant dataset.}

\item{regularization}{Select the regularization for the
likelihood estimation, e.g., BIC, AIC.}

\item{do.boot}{A parameter to disable/enable the estimation
of the error rates give the reconstructed model.}

\item{nboot}{Number of bootstrap sampling (with rejection)
to be performed when estimating the selective advantage scores.}

\item{pvalue}{Pvalue to accept/reject the valid selective
advantage relations.}

\item{min.boot}{Minimum number of bootstrap sampling
to be performed.}

\item{min.stat}{A parameter to disable/enable the minimum
number of bootstrap sampling required besides nboot if
any sampling is rejected.}

\item{boot.seed}{Initial seed for the bootstrap random
sampling.}

\item{silent}{A parameter to disable/enable verbose
messages.}

\item{epos}{Error rate of false positive errors.}

\item{eneg}{Error rate of false negative errors.}
}
\value{
A TRONCO compliant object with reconstructed
model
}
\description{
Reconstruct a progression model using Chow Liu
algorithm combined with probabilistic causation. For details and examples
regarding the inference process and on the algorithm implemented in the package,
we refer to the Vignette Section 6.
}
\examples{
data(test_dataset_no_hypos)
recon = tronco.chowliu(test_dataset_no_hypos, nboot = 1)

}
