% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.functions.R
\name{as.kfold.posterr}
\alias{as.kfold.posterr}
\title{as.kfold.posterr}
\usage{
as.kfold.posterr(
  x,
  events = as.events(x),
  models = names(x$model),
  values = FALSE,
  table = FALSE
)
}
\arguments{
\item{x}{A TRONCO model.}

\item{events}{A subset of events as of \code{as.events(x)}, all by default.}

\item{models}{A subset of reconstructed models, all by default.}

\item{values}{If you want to see also the values}

\item{table}{Keep the original table (defaul false)}
}
\value{
All the posterior classification error scores in a TRONCO model
}
\description{
Returns a dataframe with all the posterior classification error
score in a TRONCO model. It is possible to specify a subset of events
or models if multiple reconstruction have been performed.
}
\examples{
data(test_model_kfold)
data(test_model)
as.kfold.posterr(test_model_kfold)
as.kfold.posterr(test_model_kfold, events=as.events(test_model)[5:15,])

}
