% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.functions.R
\name{as.bootstrap.scores}
\alias{as.bootstrap.scores}
\title{as.bootstrap.scores}
\usage{
as.bootstrap.scores(x, events = as.events(x), models = names(x$model))
}
\arguments{
\item{x}{A TRONCO model.}

\item{events}{A subset of events as of \code{as.events(x)}, all by default.}

\item{models}{A subset of reconstructed models, all by default.}
}
\value{
All the bootstrap scores in a TRONCO model
}
\description{
Returns a dataframe with all the bootstrap score in a 
TRONCO model. It is possible to specify a subset of events
or models if multiple reconstruction have been performed.
}
\examples{
data(test_model)
as.bootstrap.scores(test_model)
as.bootstrap.scores(test_model, events=as.events(test_model)[5:15,])

}
