% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpptrAnalyzeMeltingCurves.R
\name{tpptrAnalyzeMeltingCurves}
\alias{tpptrAnalyzeMeltingCurves}
\title{Analyze fitted curve parameters to detect significant shifts in 
  melting points.}
\usage{
tpptrAnalyzeMeltingCurves(
  data,
  pValMethod = "robustZ",
  pValFilter = list(minR2 = 0.8, maxPlateau = 0.3),
  pValParams = list(binWidth = 300)
)
}
\arguments{
\item{data}{list of ExpressionSets containing fold changes and metadata. Their
featureData fields contain the fitted melting curve parameters.}

\item{pValMethod}{Method for p-value computation. Currently restricted to
'robustZ' (see Cox & Mann (2008)).}

\item{pValFilter}{optional list of filtering criteria to be applied before 
p-value computation.}

\item{pValParams}{optional list of parameters for p-value computation.}
}
\value{
A data frame in which the fit results are stored row-wise for each 
  protein.
}
\description{
Compute p-values for the pairwise comparisons of melting curve 
  shifts between different conditions.
}
\details{
The \code{pValParams} argument is a list that can contain optional parameters 
  for the chosen p-value computation \code{pValMethod}. The following options are
  available: \enumerate{ \item \code{pValMethod = "robustZ"}:
  
  \code{pValParams=list(binWidth=[your_binWidth])}.}
}
\examples{
data(hdacTR_smallExample)
tpptrData <- tpptrImport(hdacTR_config, hdacTR_data)
tpptrNorm <- tpptrNormalize(data=tpptrData, 
                            normReqs=tpptrDefaultNormReqs())
normalizedData <- tpptrNorm$normData
\dontrun{
# Fit melting curves to each protein 
# (can take some time depending on device used):
 fittedData <- tpptrCurveFit(normalizedData, nCores=1)
 resultTable <- tpptrAnalyzeMeltingCurves(fittedData)
 subset(resultTable, fulfills_all_4_requirements)$Protein_ID
}

}
\references{
Cox, J., & Mann, M. (2008). MaxQuant enables high peptide 
  identification rates, individualized ppb-range mass accuracies and 
  proteome-wide protein quantification. Nature biotechnology, 26(12), 
  1367-1372.
}
