% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tppQCPlotsCorrelateExperiments.R
\name{tppQCPlotsCorrelateExperiments}
\alias{tppQCPlotsCorrelateExperiments}
\title{Visually compare fold changes of different TPP experiments.}
\usage{
tppQCPlotsCorrelateExperiments(
  tppData,
  annotStr = "",
  path = NULL,
  ggplotTheme = tppDefaultTheme()
)
}
\arguments{
\item{tppData}{List of expressionSets with data to be plotted.}

\item{annotStr}{String with additional information to be added to the plot.}

\item{path}{Location where to store resulting plot.}

\item{ggplotTheme}{ggplot theme for the created plots.}
}
\value{
List of plots for each experiment.
}
\description{
Plot pairwise relationships between the proteins in different TPP
  experiments.
}
\examples{
data(hdacTR_smallExample)
tpptrData <- tpptrImport(configTable=hdacTR_config, data=hdacTR_data)
# Quality control (QC) plots BEFORE normalization:
tppQCPlotsCorrelateExperiments(tppData=tpptrData, 
annotStr="Non-normalized Fold Changes")
# Quality control (QC) plots AFTER normalization:
tpptrNorm <- tpptrNormalize(data=tpptrData, normReqs=tpptrDefaultNormReqs())
tpptrDataNormalized <- tpptrNorm$normData
tppQCPlotsCorrelateExperiments(tppData=tpptrDataNormalized, 
annotStr="Normalized Fold Changes")

}
\seealso{
\code{\link{tppDefaultTheme}}
}
