% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdacTR_smallExample.R
\name{hdacTR_data}
\alias{hdacTR_data}
\title{TPP-TR example dataset.}
\description{
Example subset of a dataset obtained by TPP-TR experiments to 
  investigate possible targets for HDAC inhibitor Panobinostat.
}
\details{
\code{hdacTR_data} is a list of data frames that contain
  measurements for HDACs as well as a random selection of 500 further
  proteins.
  
  You can use this dataset to explore the \code{\link{TPP}} package 
  functionalities without invoking the whole time consuming analysis on the 
  whole dataset.
  
  The original dataset is located in the folder 
  \code{'example_data/TR_example_data'} in the package's installation
  directory. You can find it on your system by the \code{R} command
  \code{system.file('example_data', package = 'TPP')}.
  
  The measurements were generated by four separate multiplexed TMT 
  experiments with 10 TMT labels each.
  Quantitative values per protein were obtained by the python  
  software isobarQuant and converted to fold changes relative to the lowest 
  temperature.
  The raw data before quantification can be found in the \code{proteomicsDB}
  database (http://www.proteomicsdb.org/#projects/4221/3101) with the following sample mapping:
  
  \itemize{ 
  \item{\code{Panobinostat_1}: }{MS-experiment numbers P85192B02-B10} 
  \item{\code{Panobinostat_2}: }{MS-experiment numbers P85881B02-B10} 
  \item{\code{Vehicle_1}: }{MS-experiment numbers P85202B02-B10} 
  \item{\code{Vehicle_2}: }{MS-experiment numbers P85891B02-B10} 
  }
}
\references{
Franken, H, Mathieson, T, Childs, D. Sweetman, G. Werner, T. Huber, W. & Savitski, M. M. (2015),
  Thermal proteome profiling for unbiased identification of drug targets and detection of downstream effectors.
  Nature protocols 10(10), 1567-1593.
}
\seealso{
\code{\link{hdacTR_smallExample}}, \code{\link{hdacTR_config}}
}
