% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdr_funcs.R
\name{findHits}
\alias{findHits}
\title{Find hits according to FDR threshold}
\usage{
findHits(fdr_df, alpha)
}
\arguments{
\item{fdr_df}{data frame obtained from computeFdr}

\item{alpha}{significance threshold, default is set to 0.1}
}
\value{
data frame of significant hits at FDR <= alpha
}
\description{
Find hits according to FDR threshold
}
\examples{
data("simulated_cell_extract_df")
temp_df <- simulated_cell_extract_df \%>\% 
  filter(clustername \%in\% paste0("protein", 1:5)) \%>\% 
  group_by(representative) \%>\% 
  mutate(nObs = n()) \%>\% 
  ungroup 
example_out <- fitAndEvalDataset(temp_df)
example_null <- bootstrapNull(temp_df, B = 1)
fdr_df <- getFDR(example_out, example_null)
findHits(fdr_df, 0.1)

}
