% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external_TMixClust.R
\name{plot_time_series_df}
\alias{plot_time_series_df}
\title{Plots all the time series stored in a data frame object}
\usage{
plot_time_series_df(ts_df, time_points = seq_len(ncol(ts_df)),
  data_color = "#fd8d3c", x_label = "time", y_label = "value",
  plot_title = "Time series plot")
}
\arguments{
\item{ts_df}{data frame containing on each row a time-series}

\item{time_points}{vector containing the values of the time points.
Default: \code{seq_len(ncol(time_series_df))}.}

\item{data_color}{color of the time series to be used for the plot.
Default is orange.}

\item{x_label}{label of the x axis of the plot. Default is "time"}

\item{y_label}{label of the y axis of the plot. Default is "value"}

\item{plot_title}{title of the plot. Default is "Time series plot".}
}
\value{
Plots a figure with all the the time series in the data set
}
\description{
\code{plot_time_series_df} allows the user to visualise the time
 series from a given data set.
}
\examples{
# Load the toy time series data provided with the TMixClust package
data(toy_data_df)

# Plot the time series
plot_time_series_df(toy_data_df)
}
\references{
Golumbeanu M, Desfarges S, Hernandez C, Quadroni M, Rato S,
Mohammadi P, Telenti A, Beerenwinkel N, Ciuffi A. (2017) Dynamics of
Proteo-Transcriptomic Response to HIV-1 Infection.
}
\author{
Monica Golumbeanu, \email{monica.golumbeanu@bsse.ethz.ch}
}
