% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external_TMixClust.R
\name{TMixClust}
\alias{TMixClust}
\title{Clusters the time series data in a given number of groups}
\usage{
TMixClust(time_series_df, time_points = seq_len(ncol(time_series_df)),
  nb_clusters = 2, em_iter_max = 1000, mc_em_iter_max = 10,
  em_ll_convergence = 0.001)
}
\arguments{
\item{time_series_df}{data frame containing the time series.
Each row is a time series comprised of the time series name which is also the
 row name, and the time series values at each time point.}

\item{time_points}{vector containing numeric values for the time points.
Default: \code{seq_len(ncol(time_series_df))}.}

\item{nb_clusters}{desired number of clusters}

\item{em_iter_max}{maximum number of iterations for the
expectation-maximization (EM) algorithm. Default: 1000.}

\item{mc_em_iter_max}{maximum number of iterations for Monte-Carlo
resampling. Default is 100.}

\item{em_ll_convergence}{convergence threshold for likelihood improvement.
Default is 0.001.}
}
\value{
list object with the following attributes:
\itemize{
\item \code{em_gss_obj_list} object of class \code{gss} containing
estimated parameters of the mixed-effects model
(see package vignette for more details).
\item \code{em_pi_k} vector containing the mixing coefficients
corresponding to each cluster
\item \code{em_mat_post} matrix containing the posterior values for each
time series and cluster
\item \code{em_cluster_assignment} vector with the clustering attribution
for each time series
\item \code{el_ll} vector containing the log likelihood values at each
iteration in the EM algorithm
\item \code{ts_data} the same as the input time series data-frame
\item \code{ts_time_points} the same as the input time-points vector
}
}
\description{
\code{TMixClust} is the central function of the package.
It clusters the given time series data into a specified number of clusters.
}
\examples{
# Load the toy time series data provided with the TMixClust package
data(toy_data_df)

# Cluster the toy data with default parameters
TMixClust_obj = TMixClust(toy_data_df)

}
\references{
Golumbeanu M, Desfarges S, Hernandez C, Quadroni M, Rato S,
Mohammadi P, Telenti A, Beerenwinkel N, Ciuffi A. (2017) Dynamics of
Proteo-Transcriptomic Response to HIV-1 Infection.
}
\author{
Monica Golumbeanu, \email{monica.golumbeanu@bsse.ethz.ch}
}
