% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomposeSets.R
\name{decomposeSets}
\alias{decomposeSets}
\title{Decompose Pairs of Overlapping Sets Into 3 Disjoint Parts}
\source{
Decomposition of sets is described by Jiang and Gentleman (2007) in
section 2.3.1 "Overlap among gene sets". It is a method to reduce the
redundancy of significant gene set testing results whereby the decomposed
sets are reanalyzed and the following selections can be made:

\itemize{
\item{If the elements unique to set 1 and set 2, elements common to both
sets, or all 3 parts are statistically significant, keep both set 1 and set
2 in the original results. We can not separate their effects.}

\item{If the elements unique to set 1 or the elements unique to set 1 and
common to both sets are statistically significant, only keep set 1 in the
original results. (The same logic can be applied for set 2.)}
}
}
\usage{
decomposeSets(
  x,
  overlap = 1L,
  AND = "~AND~",
  MINUS = "~MINUS~",
  verbose = TRUE
)
}
\arguments{
\item{x}{a named list of sets. Elements must be of type \code{"character"}.}

\item{overlap}{integer; only pairs of sets with at least \code{overlap}
elements in common will be decomposed.}

\item{AND}{character; string used to denote the intersection of two sets.
Defaut is "~AND~", which produces intersections of the form "A ~AND~ B"
(i.e., elements in both A and B).}

\item{MINUS}{character; string used to denote the difference of two sets.
Defualt is "~MINUS~", which produces differences of the form "A ~MINUS~ B"
(i.e., elements in A and not in B).}

\item{verbose}{logical; whether to print warnings and messages.}
}
\value{
A named list of disjoint parts of sets. May contain aliases.
}
\description{
Decompose all pairs of sufficiently overlapping sets into 3
disjoint parts: the elements unique to the first set, the elements unique
to the second set, and the elements found in both sets. See the examples
section in \code{\link{invertSets}} for a method to decompose an entire
list of sets.
}
\section{Optimization}{


Since the size of the intersection between two sets is at most the size of
the smaller set, any sets with fewer than \code{overlap} elements can be
immediately discarded.
}

\examples{
x <- list("A" = letters[1:10],
          "B" = letters[3:7],
          "C" = letters[1:4],
          "D" = letters[6:12])

decomposeSets(x)

decomposeSets(x, overlap = 5L)
}
\references{
Jiang, Z., & Gentleman, R. (2007). Extensions to gene set enrichment.
\emph{Bioinformatics, 23}(3), 306–313.
doi:\href{https://doi.org/10.1093/bioinformatics/btl599
}{10.1093/bioinformatics/btl599}
}
\seealso{
\code{\link{filterSets}}
}
