% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All-functions.R
\name{txt2GR}
\alias{txt2GR}
\title{Function to filter a ChIP-Seq input.}
\usage{
txt2GR(fileTable, format, fileMetaData, alpha = NULL)
}
\arguments{
\item{fileTable}{data frame from a txt/tsv/bed file}

\item{format}{'narrowpeak', 'macs1.4' or 'macs2'.
narrowPeak fields:
'chrom','chromStart','chromEnd','name','score','strand','signalValue',
'pValue','qValue','peak'
macs1.4 fields:
'chrom','chromStart','chromEnd','name','-10*log10(p-value)'
macs2 fields:
'chrom','chromStart','chromEnd','name','-log10(p-value)'}

\item{fileMetaData}{Data frame/matrix/array contaning the following
fields: 'Name','Accession','Cell','Cell Type','Treatment','Antibody',
'TF'.}

\item{alpha}{max p-value to consider ChIPseq peaks as significant and
include them in the database. By default alpha is 0.05 for narrow peak
files and 1e-05 for MACS files}
}
\value{
The function returns a GR object generated from the ChIP-Seq
dataset input.
}
\description{
Function to filter a ChIP-Seq output (in .narrowpeak or
MACS's peaks.bed formats) and then store the peak coordinates in a
GenomicRanges object, associated to its metadata.
}
\examples{
data('ARNT.peaks.bed','ARNT.metadata',package = 'TFEA.ChIP')
ARNT.gr<-txt2GR(ARNT.peaks.bed,'macs1.4',ARNT.metadata)
}
