% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All-functions.R
\name{plot_RES}
\alias{plot_RES}
\title{Plot Running Enrichment Scores (RES) and Log2 Fold Change (LFC)}
\usage{
plot_RES(
  GSEA_result,
  LFC,
  plot_title = NULL,
  line.colors = NULL,
  line.styles = NULL,
  Accession = NULL,
  TF = NULL
)
}
\arguments{
\item{GSEA_result}{List returned by GSEA_run, containing the enrichment 
table and RES.}

\item{LFC}{Numeric vector containing the log2(Fold Change) of every gene 
with an Entrez ID, ordered from highest to lowest.}

\item{plot_title}{(Optional) String specifying the title for the plot.
Default is "Transcription Factor Enrichment".}

\item{line.colors}{(Optional) Character vector specifying colors for each 
line in the RES plot. If NULL, default colors will be used.}

\item{line.styles}{(Optional) Character vector specifying line styles for 
each RES line. Possible values are 'solid', 'dash', or 'longdash'.}

\item{Accession}{(Optional) Character vector specifying accession IDs to
restrict the plot to. If NULL, all accession IDs will be plotted.}

\item{TF}{(Optional) Character vector specifying TF names to restrict 
the plot to. If NULL, all transcription factors will be plotted.}
}
\value{
A Plotly object containing two subplots: the top one showing the 
running enrichment scores (RES) for the filtered accession IDs or 
TFs, and the bottom one displaying the log2 fold
change (LFC) as a bar plot.
}
\description{
This function plots the running enrichment scores (RES) from 
a GSEA result, with an additional bar plot showing the log2 fold change 
(LFC) of genes. The RES plot can be filtered by TFs or accession IDs.
}
\examples{
data('GSEA.result', 'log2.FC', package = 'TFEA.ChIP')
GSEA_result <- GSEA.result
plot_RES(GSEA_result, log2.FC, 
         TF = c('E2F4', 'E2F1'),
         Accession = c('ENCSR000DYY.E2F4.GM12878', 
                       'ENCSR000EVJ.E2F1.HeLa-S3'))
}
