% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All-functions.R
\name{makeChIPGeneDB}
\alias{makeChIPGeneDB}
\title{Make a ChIP - target database}
\usage{
makeChIPGeneDB(Ref.db, gr.list, distanceMargin = 10, min.Targets = 10)
}
\arguments{
\item{Ref.db}{GenomicRanges object containing a database of reference
elements (either Genes or gene-associated regions) including a gene_id
metacolumn}

\item{gr.list}{List of GR objects containing ChIP-seq peak coordinates
(output of txt2GR).}

\item{distanceMargin}{Maximum distance allowed between a gene or 
regulatory element to assign a gene to a ChIP-seq peak. Set to 10 bases
by default.}

\item{min.Targets}{Minimum number of putative targets per ChIP-seq in
gr.list. ChIPs with fewer targets will be discarded.
regulatory element to assign a gene to a ChIP-seq peak. Set to 10 bases
by default.}
}
\value{
List containing two elements:
   - Gene Keys: vector of gene IDs
   - ChIP Targets: list of vectors, one per element in gr.list, 
     containing the putative targets assigned. Each target is coded as
     its position in the vector 'Gene Keys'.
}
\description{
makeChIPGeneDB generates a ChIP-seq - target database
through the association of ChIP-Seq peak coordinates (provided
as a GenomicRange object) to overlapping genes or gene-associated
genomic regions (Ref.db).
}
\examples{
data( 'DnaseHS_db','gr.list', package = 'TFEA.ChIP' )
makeChIPGeneDB( DnaseHS_db, gr.list )
}
