% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All-functions.R
\name{GSEA_ESpermutations}
\alias{GSEA_ESpermutations}
\title{Calculate enrichment scores for a permutation test.}
\usage{
GSEA_ESpermutations(
  gene.list,
  gene.set,
  weighted.score.type = 0,
  correl.vector = NULL,
  perms = 1000
)
}
\arguments{
\item{gene.list}{Vector of gene Entrez IDs.}

\item{gene.set}{A gene set, e.g. gene IDs corresponding to a ChIP-Seq
experiment's peaks.}

\item{weighted.score.type}{Type of score: weight:
0 (unweighted = Kolmogorov-Smirnov), 1 (weighted), and 2 (over-weighted)}

\item{correl.vector}{A vector with the correlations (such as signal to
noise scores) corresponding to the genes in the gene list}

\item{perms}{Number of permutations}
}
\value{
Vector of Enrichment Scores for a permutation test.
}
\description{
Function to calculate enrichment scores over a randomly 
ordered gene list.
}
\examples{
GSEA_ESpermutations(gene.list=c('3091','2034','405','55818'),
gene.set=c('2034','112399','405'), perms=10)
}
