% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IPCA.R
\name{IPCA}
\alias{IPCA}
\title{Principal Components Analysis for distributions of variations of support and 
confidence obtained removing a transcription factor
from a set of rules.}
\usage{
IPCA(delta_list, IMP)
}
\arguments{
\item{delta_list}{list of variations of distributions
of support and confidence measures, obtained using the \code{IComp}.}

\item{IMP}{the importance matrix with the mean Importance Index
of every candidate co-regulator transcription factor and the number of rules
in which each of them appears.}
}
\value{
Variance explained by every principal component (\code{summary}),
scores (i.e., the coordinates) of data in delta_list in the reference system
defined by the principal components (\code{scores}) and loadings
(i.e., the coefficinets) of the linear combination that defines
each principal component (\code{loadings}).
The plots of the variability, the cumulate percentage of variance explained
by each principal component and loadings of every principal component are
also returned.
}
\description{
The function is used for validation of the defined Importance Index.
It is defined as the linear combination of variations of
support and confidence measures.
The Principal Component Analysis lets the user evaluate
if in the 1D reference system defined by such linear combination,
it is possible to describe the variability of the data.
}
\examples{
# Load IMP, DELTA and TF_Imp from the data_man collection of datasets:
data('data_man')

colnames(IMP)
TF_Imp <- data.frame(IMP$TF, IMP$imp, IMP$nrules)
i.pc <- IPCA(DELTA, TF_Imp)
names(i.pc)
}
