% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step7TopGenesUCSCBedFiles.R
\name{step7TopGenesUCSCBedFiles}
\alias{step7TopGenesUCSCBedFiles}
\title{Create BED-formatted interact files which can be loaded on the UCSC
Genome Browser to display links between top genes and transcription factors
and their linked RE DNA methylation sites}
\usage{
step7TopGenesUCSCBedFiles(
  TENETMultiAssayExperiment,
  outputDirectory,
  geneAnnotationDataset = NA,
  DNAMethylationArray = NA,
  hypermethGplusAnalysis = TRUE,
  hypomethGplusAnalysis = TRUE,
  topGeneNumber = 10
)
}
\arguments{
\item{TENETMultiAssayExperiment}{Specify a MultiAssayExperiment object
containing expression and methylation SummarizedExperiment objects, such as
one created by the TCGADownloader function. The object's metadata must
contain the results from the \code{step5OptimizeLinks} and
\code{step6DNAMethylationSitesPerGeneTabulation} functions.}

\item{outputDirectory}{Specify the path to the output directory in which to
save the \code{.inter.bed} files created by this function. It will be created if
necessary.}

\item{geneAnnotationDataset}{Specify a gene annotation dataset which is
used to identify names for genes by their Ensembl IDs. The argument must be
either a GRanges object (such as one imported via \code{rtracklayer::import}) or a
path to a GFF3 or GTF file. Both GENCODE and Ensembl annotations are
supported. Other annotation datasets may work, but have not been tested.
See the "Input data" section of the vignette for information on the required
dataset format.
Specify NA to use the gene names listed in the "geneName" column of the
elementMetadata of the rowRanges of the "expression" SummarizedExperiment
object within the TENETMultiAssayExperiment object. Defaults to NA.}

\item{DNAMethylationArray}{Specify the name of a DNA methylation probe array
supported by the sesameData package (see
\code{?sesameData::sesameData_getManifestGRanges}). If an array is specified, RE
DNA methylation sites and their locations in that array's manifest are
cross-referenced with RE DNA methylation site IDs included in the rownames
of the methylation dataset provided in the "methylation"
SummarizedExperiment object within the TENETMultiAssayExperiment object, and
only those overlapping will be considered for analysis. If set to NA, all RE
DNA methylation sites with locations listed in the rowRanges of the
"methylation" SummarizedExperiment object are used. Defaults to NA.}

\item{hypermethGplusAnalysis}{Set to TRUE to create interact files showing
links between the top genes and TFs by most RE hypermethylated RE DNA
methylation sites with G+ links and their linked RE DNA methylation sites.
Defaults to TRUE.}

\item{hypomethGplusAnalysis}{Set to TRUE to create interact files showing
links between the top genes and TFs by most hypomethylated RE DNA methylation
sites with G+ links and their linked RE DNA methylation sites. Defaults to
TRUE.}

\item{topGeneNumber}{Specify the number of top genes and TFs, based on the
most linked RE DNA methylation sites of a given analysis type, for which to
generate interact files showing the links between those genes and each of
their linked RE DNA methylation sites. Defaults to 10.}
}
\value{
Outputs BED-formatted interact files to upload to the UCSC Genome
Browser to the specified output directory. These files display the
interactions between the top genes/TFs and their linked RE DNA methylation
sites for the given analysis types. Returns a list of lists named after each
selected analysis type, each containing the file paths to the created
\code{.inter.bed} files for top genes and top TFs for that analysis type.
}
\description{
This function takes the top genes and transcription factors (TFs) by number
of linked RE DNA methylation sites identified by the
\code{step6DNAMethylationSitesPerGeneTabulation} function in the hyper- and/or
hypomethylated G+ analysis quadrants, up to the number specified by the user,
and generates BED-formatted interact files (see
\url{https://genome.ucsc.edu/goldenPath/help/interact.html}) that can be
uploaded to the UCSC Genome Browser (\url{https://genome.ucsc.edu}) to visualize
the links between each of these genes and the RE DNA methylation sites linked
to them for the given analysis type.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
## This example uses the example MultiAssayExperiment provided in the
## TENET.ExperimentHub package to create UCSC Genome Browser interact files
## for the top 10 genes and TFs by number of linked hyper- and hypomethylated
## RE DNA methylation sites. The interact files for the top genes and TFs
## will be saved in the user's working directory. Gene names and locations,
## and the locations of RE DNA methylation sites, will be retrieved from the
## rowRanges of the 'expression' and 'methylation' SummarizedExperiment
## objects in the example MultiAssayExperiment.

## Load the example TENET MultiAssayExperiment object
## from the TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Use the example dataset to create the UCSC Genome Browser interact files
filePaths <- step7TopGenesUCSCBedFiles(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment,
    outputDirectory = "."
)

## Get the path to the .inter.bed file for the top TFs by number of
## hypomethylated G+ RE DNA methylation sites
filePaths$hypoGplus$topTFs

## This example is similar, but creates UCSC Genome Browser interact files
## for only the top 5 genes and TFs by number of linked hypomethylated RE DNA
## methylation sites, and RE DNA methylation site IDs and locations are
## retrieved from the HM450 array via the sesameData package.

## Load the example TENET MultiAssayExperiment object
## from the TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Use the example dataset to create the UCSC Genome Browser interact files
filePaths <- step7TopGenesUCSCBedFiles(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment,
    outputDirectory = ".",
    DNAMethylationArray = "HM450",
    hypermethGplusAnalysis = FALSE,
    topGeneNumber = 5
)

## Get the path to the .inter.bed file for the top TFs by number of
## hypomethylated G+ RE DNA methylation sites.
## Note: Since we performed analyses only using TFs in the step 3 function,
## the top genes are all TFs, so topTFs will be NA and topGenes must be used
## instead.
filePaths$hypoGplus$topGenes
\dontshow{\}) # examplesIf}
}
