% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step7TopGenesExpressionCorrelationHeatmaps.R
\name{step7TopGenesExpressionCorrelationHeatmaps}
\alias{step7TopGenesExpressionCorrelationHeatmaps}
\title{Generate mirrored heatmaps displaying the correlation of the expression
values of the top genes and TFs}
\usage{
step7TopGenesExpressionCorrelationHeatmaps(
  TENETMultiAssayExperiment,
  geneAnnotationDataset = NA,
  hypermethGplusAnalysis = TRUE,
  hypomethGplusAnalysis = TRUE,
  topGeneNumber = 10
)
}
\arguments{
\item{TENETMultiAssayExperiment}{Specify a MultiAssayExperiment object
containing expression and methylation SummarizedExperiment objects, such as
one created by the TCGADownloader function. The object's metadata must
contain the results from the \code{step6DNAMethylationSitesPerGeneTabulation}
function.}

\item{geneAnnotationDataset}{Specify a gene annotation dataset which is
used to identify names for genes by their Ensembl IDs. The argument must be
either a GRanges object (such as one imported via \code{rtracklayer::import}) or a
path to a GFF3 or GTF file. Both GENCODE and Ensembl annotations are
supported. Other annotation datasets may work, but have not been tested.
See the "Input data" section of the vignette for information on the required
dataset format.
Specify NA to use the gene names listed in the "geneName" column of the
elementMetadata of the rowRanges of the "expression" SummarizedExperiment
object within the TENETMultiAssayExperiment object. Defaults to NA.}

\item{hypermethGplusAnalysis}{Set to TRUE to create heatmaps and tables
showing expression correlation values for the top genes and TFs with the most
hypermethylated RE DNA methylation sites with G+ links. Defaults to TRUE.}

\item{hypomethGplusAnalysis}{Set to TRUE to create heatmaps and tables
showing expression correlation values for the top genes and TFs with the most}

\item{topGeneNumber}{Specify the number of top genes and TFs, based on the
most linked RE DNA methylation sites of a given analysis type, for which to
generate expression correlation heatmaps and tables. Defaults to 10.}
}
\value{
Returns the MultiAssayExperiment object given as the
TENETMultiAssayExperiment argument with an additional list named
'step7TopGenesExpressionCorrelationHeatmaps' in its metadata containing the
output of this function. This list contains \code{hypermethGplus} and/or
\code{hypomethGplus} lists, as selected by the user, which contain lists for the
top overall genes and top TF genes. These lists contain a mirrored heatmap
displaying the expression correlation values for these genes and a data frame
containing the names and correlation values for each gene.
}
\description{
This function takes the top genes and TFs for each analysis type by number of
linked RE DNA methylation sites identified by the
\code{step6DNAMethylationSitesPerGeneTabulation} function, up to the number
specified by the user, and generates heatmaps displaying the correlation of
the expression of each of the top genes and TFs in the case samples. Each of
the genes is displayed in both the rows and columns, so the heatmaps are
mirrored, with correlation values of each gene to itself displayed in a
diagonal line in the center of the heatmaps. Red values represent positive
correlation and blue values represent negative correlation, with darker
colors representing a stronger correlation. Dendrograms are included to
identify genes which are closely related in expression correlation.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
## This example uses the example MultiAssayExperiment provided in the
## TENET.ExperimentHub package to create correlation heatmaps, and
## corresponding tables, for the top 10 genes and TFs by number of
## linked hyper- and hypomethylated RE DNA methylation sites. Gene names will
## be retrieved from the rowRanges of the 'expression' SummarizedExperiment
## object in the example MultiAssayExperiment.

## Load the example TENET MultiAssayExperiment object
## from the TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Use the example dataset to create expression correlation heatmaps
returnValue <- step7TopGenesExpressionCorrelationHeatmaps(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment
)

## This example is similar, but creates heatmaps and tables for only the
## top 5 genes and TFs by number of linked hypomethylated RE DNA methylation
## sites.

## Load the example TENET MultiAssayExperiment object
## from the TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Use the example dataset to create expression correlation heatmaps
returnValue <- step7TopGenesExpressionCorrelationHeatmaps(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment,
    hypermethGplusAnalysis = FALSE,
    topGeneNumber = 5
)
\dontshow{\}) # examplesIf}
}
