% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step1MakeExternalDatasets.R
\name{step1MakeExternalDatasets}
\alias{step1MakeExternalDatasets}
\title{Create a GRanges object representing putative regulatory element regions,
based on the data sources selected for inclusion, to be used in later
TENET steps}
\usage{
step1MakeExternalDatasets(
  extHM = NA,
  extNDR = NA,
  consensusEnhancer = TRUE,
  consensusPromoter = FALSE,
  consensusNDR = TRUE,
  publicEnhancer = FALSE,
  publicPromoter = FALSE,
  publicNDR = FALSE,
  cancerType = NA,
  ENCODEPLS = FALSE,
  ENCODEpELS = FALSE,
  ENCODEdELS = FALSE
)
}
\arguments{
\item{extHM}{To use custom histone modification datasets, specify one or more
paths to .bed, .narrowPeak, .broadPeak, and/or .gappedPeak files containing
these datasets, or directories containing these file types. The files may
optionally be compressed (.gz/.bz2/.xz). Otherwise, specify NA or do not
specify this argument.}

\item{extNDR}{To use custom open chromatin or NDR datasets, specify one or
more paths to .bed, .narrowPeak, .broadPeak, and/or .gappedPeak files
containing these datasets, or directories containing these file types. The
files may optionally be compressed (.gz/.bz2/.xz). Otherwise, specify NA or
do not specify this argument.}

\item{consensusEnhancer}{Set to TRUE to use the consensus enhancer data
included in TENET.AnnotationHub. Defaults to TRUE.}

\item{consensusPromoter}{Set to TRUE to use the consensus promoter data
included in TENET.AnnotationHub. Defaults to FALSE.}

\item{consensusNDR}{Set to TRUE to use the consensus open chromatin (NDR)
data included in TENET.AnnotationHub. Defaults to TRUE.}

\item{publicEnhancer}{Set to TRUE to use the preprocessed publicly available
enhancer (H3K27ac) datasets included in TENET.AnnotationHub. If set to TRUE,
\code{cancerType} must be specified. Defaults to FALSE.}

\item{publicPromoter}{Set to TRUE to use the preprocessed publicly available
promoter (H3K4me3) datasets included in TENET.AnnotationHub. If set to TRUE,
\code{cancerType} must be specified. Defaults to FALSE.}

\item{publicNDR}{Set to TRUE to use the preprocessed publicly available
open chromatin (ATAC-seq, DNase-seq) datasets included in
TENET.AnnotationHub. If set to TRUE, \code{cancerType} must be specified.
Defaults to FALSE.}

\item{cancerType}{If \code{publicEnhancer}, \code{publicPromoter}, and/or \code{publicNDR}
is TRUE, specify a vector of cancer types ('BLCA', 'BRCA', 'COAD',
'ESCA', 'HNSC', 'KIRP', 'LIHC', 'LUAD', 'LUSC', and/or 'THCA') to include the
public data relevant to those cancer types. Defaults to NA.}

\item{ENCODEPLS}{Set to TRUE to use the ENCODE promoter-like elements
dataset included in TENET.AnnotationHub. Defaults to FALSE.}

\item{ENCODEpELS}{Set to TRUE to use the ENCODE proximal enhancer-like
elements dataset included in TENET.AnnotationHub. Defaults to FALSE.}

\item{ENCODEdELS}{Set to TRUE to use the ENCODE distal enhancer-like
elements dataset included in TENET.AnnotationHub. Defaults to FALSE.}
}
\value{
Returns the created regulatory element GRanges object.
}
\description{
This function creates a GRanges object containing regions representing
putative regulatory elements, either enhancers or promoters, of
interest to the user, based on the presence of specific histone marks
and open chromatin/nucleosome-depleted regions. This function can take input
from user-specified BED-like files (see
\url{https://genome.ucsc.edu/FAQ/FAQformat.html#format1}) containing regions with
histone modification (via the \code{extHM} argument) and/or open
chromatin/nucleosome-depleted regions (via the \code{extNDR} argument), as well
as preprocessed enhancer, promoter, and open chromatin datasets from many
cell/tissue types included in the TENET.AnnotationHub repository. The
resulting GRanges object will be returned. GRanges objects created by this
function can be used by the \code{step2GetDifferentiallyMethylatedSites} function
or other downstream functions. \strong{Note:} Using datasets from
TENET.AnnotationHub requires an internet connection, as those datasets are
hosted in the Bioconductor AnnotationHub Data Lake.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
## This example creates a dataset of putative enhancer regulatory elements
## from consensus datasets and breast invasive carcinoma-relevant sources
## collected in the TENET.AnnotationHub package.
returnGRanges <- step1MakeExternalDatasets(
    extHM = NA,
    extNDR = NA,
    publicEnhancer = TRUE,
    publicNDR = TRUE,
    cancerType = "BRCA",
    ENCODEdELS = TRUE
)

## This example creates a dataset of putative promoter regulatory elements
## using user provided BED-like files contained in the working
## directory, consensus NDR and promoter regions, and regions with
## promoter-like signatures from the ENCODE SCREEN project. This excludes any
## cancer type-specific public datasets.
returnGRanges <- step1MakeExternalDatasets(
    extHM = ".",
    extNDR = ".",
    consensusEnhancer = FALSE,
    consensusPromoter = TRUE,
    ENCODEPLS = TRUE
)
\dontshow{\}) # examplesIf}
}
