% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appTEKRABber.R
\name{appTEKRABber}
\alias{appTEKRABber}
\title{appTEKRABber}
\usage{
appTEKRABber(corrRef, corrCompare, DEobject)
}
\arguments{
\item{corrRef}{correlation results for reference using corrOrtholgScale()}

\item{corrCompare}{correlation results for comparison using 
corrOrthologScale()}

\item{DEobject}{DE object using DEgeneTE()}
}
\value{
provide an interactive shinyapp
}
\description{
Provide a shiny UI for presenting the results from DE analysis and 
correlation analysis.
}
\examples{
data(speciesCounts)
hmGene <- speciesCounts$hmGene
hmTE <- speciesCounts$hmTE
chimpGene <- speciesCounts$chimpGene
chimpTE <- speciesCounts$chimpTE

data(fetchDataHmChimp)
fetchData <- fetchDataHmChimp
inputBundle <- DECorrInputs(fetchData)

meta <- data.frame(
species = c(rep("human", ncol(hmGene) - 1), 
            rep("chimpanzee", ncol(chimpGene) - 1)))
            
meta$species <- factor(meta$species, levels = c("human", "chimpanzee"))
rownames(meta) <- colnames(inputBundle$geneInputDESeq2)
hmchimpDE <- DEgeneTE(
    geneTable = inputBundle$geneInputDESeq2,
    teTable = inputBundle$teInputDESeq2,
    metadata = meta,
    expDesign = TRUE)

# use only 10 rows of Genes and TEs
hmCorrResult <- corrOrthologTE(
    geneInput = hmchimpDE$geneCorrInputRef[c(1:10),],
    teInput = hmchimpDE$teCorrInputRef[c(1:10),],
    corrMethod = "pearson",
    padjMethod = "fdr")
    
chimpCorrResult <- corrOrthologTE(
    geneInput = hmchimpDE$geneCorrInputCompare[c(1:10), ],
    teInput = hmchimpDE$teCorrInputCompare[c(1:10), ],
    corrMethod = "pearson",
    padjMethod = "fdr")


#library(plotly)
#appTEKRABber(
    #corrRef = hmCorrResult,
    #corrCompare = chimpCorrResult,
    #DEobject = hmchimpDE)
    
}
