% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectFeatureRect.R
\name{selectFeatureRect}
\alias{selectFeatureRect}
\title{Select features through the selection  of singular value vectors}
\usage{
selectFeatureRect(
  SVD,
  cond,
  de = rep(1e-04, 2),
  p0 = 0.01,
  breaks = 100L,
  input_all = NULL
)
}
\arguments{
\item{SVD}{SVD computed from matrix generated by partial summation of a tensor}

\item{cond}{Condition to select singular value vectors}

\item{de}{Initial values to be used for optimization of standard deviation}

\item{p0}{Threshold value for the significance}

\item{breaks}{Number of bins of histogram of P-values}

\item{input_all}{The ID of selected singular value vectors. If it is null, 
interactive mode is activated.}
}
\value{
List of lists that includes P-vales as well as if individual
 features selected.
}
\description{
Select features through the selection  of singular value vectors
}
\examples{
set.seed(0)
matrix1 <- matrix(runif(2000),200)
matrix2 <- matrix(runif(4000),200)
SVD <- computeSVD(matrix1,matrix2)
index_all <- selectFeatureRect(SVD,
list(NULL,rep(seq_len(2),each=5),rep(seq_len(2),each=10)),de=rep(0.5,2),
input_all=1)
}
