% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectFeatureProj.R
\name{selectFeatureProj}
\alias{selectFeatureProj}
\title{Select feature when projection strategy is employed for the
 case where features are shared with multiple omics profiles}
\usage{
selectFeatureProj(
  HOSVD,
  Multi,
  cond,
  de = 1e-04,
  p0 = 0.01,
  breaks = 100L,
  input_all = NULL
)
}
\arguments{
\item{HOSVD}{HOSVD}

\item{Multi}{list of omics profiles, row: sample, column: feature}

\item{cond}{list of conditions for individual omics profiles}

\item{de}{initial value for optimization of standard deviation}

\item{p0}{Threshold P-value}

\item{breaks}{The number of bins of histogram of P-values}

\item{input_all}{The number of selected feature. if null, interactive mode
is activated}
}
\value{
list composed of logical vector that represent which features are selected and p-values
}
\description{
Select feature when projection strategy is employed for the
 case where features are shared with multiple omics profiles
}
\examples{
library(TDbasedUFE)
Multi <- list(matrix(runif(1000),10),matrix(runif(1000),10),
matrix(runif(1000),10),matrix(runif(1000),10))
Z <- prepareTensorfromList(Multi,10L)
Z <- aperm(Z,c(2,1,3))
Z <- PrepareSummarizedExperimentTensor(feature =as.character(1:10),
                                      sample=array("",1),value=Z)
HOSVD <- computeHosvd(Z)
cond <- rep(list(rep(1:2,each=5)),4)
index <- selectFeatureProj(HOSVD,Multi,cond,de=0.1,input_all=2)
}
