% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareTensorRect.R
\name{prepareTensorRect}
\alias{prepareTensorRect}
\title{Prepare tensor generated from two matrices that share samples}
\usage{
prepareTensorRect(
  sample,
  feature,
  value,
  featureRange = GRanges(NULL),
  sampleData = list(NULL)
)
}
\arguments{
\item{sample}{Character vector of sample names}

\item{feature}{list of features from two matrices}

\item{value}{array, contents of}

\item{featureRange}{Genomic Ranges to be associated with features}

\item{sampleData}{List of conditional labeling associated with samples}
}
\value{
Tensor generated from two matrices that share samples
}
\description{
Prepare tensor generated from two matrices that share samples
}
\examples{
matrix1 <- matrix(runif(1000),200) #row features, column samples
matrix2 <- matrix(runif(2000),400) #row features, column samples
Z <- prepareTensorfromMatrix(t(matrix1),t(matrix2))
Z <- prepareTensorRect(sample=as.character(seq_len(50)),
feature=list(as.character(seq_len(200)),as.character(seq_len(400))),
sampleData=list(rep(seq_len(2),each=25)),value=Z)
}
