% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectFeatureSquare.R
\name{selectFeatureSquare}
\alias{selectFeatureSquare}
\title{Title
Select features (for tensor generated from squared matrix)}
\usage{
selectFeatureSquare(
  HOSVD,
  input_all,
  Multi,
  de = rep(1e-04, dim(HOSVD$U[[3]])[2]),
  p0 = 0.01,
  breaks = 100,
  interact = TRUE
)
}
\arguments{
\item{HOSVD}{output from HOSVD applied to tensor generated
from squared matrix}

\item{input_all}{Selected singular value vector IDs}

\item{Multi}{Multiomics data}

\item{de}{Initial value for optimization of standard deviation}

\item{p0}{Threshold P-value}

\item{breaks}{The number of bins}

\item{interact}{if interact mode or not}
}
\value{
List that includes selected features and computed P-value
}
\description{
Title
Select features (for tensor generated from squared matrix)
}
\examples{
omics1 <- matrix(runif(100000),ncol=10)
dimnames(omics1) <- list(seq_len(10000),seq_len(10))
omics2 <- matrix(runif(100000),ncol=10)
dimnames(omics2) <- dimnames(omics1)
Multi <- list(omics1,omics2)
Z <- PrepareSummarizedExperimentTensorSquare(
sample=matrix(colnames(omics1),1),
feature=list(omics1=rownames(omics1),
omics2=rownames(omics2)),
value=convertSquare(Multi),
sampleData=list(NA))
HOSVD <- computeHosvdSqure(Z)
cond <- list(0,rep(seq_len(2),each=5),c("A","B"))
input_all <- selectSingularValueVectorLarge(HOSVD,cond,input_all=c(1,1))
index <- selectFeatureSquare(HOSVD,input_all,Multi,de=c(0.1,0.1),
interact=FALSE)
}
