% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakreference.R
\name{peakreference}
\alias{peakreference}
\title{combine and merge multiple BED files}
\usage{
peakreference(
  data = NULL,
  dir = NULL,
  pattern = NULL,
  merge = TRUE,
  overlap = 1,
  ratio = NULL
)
}
\arguments{
\item{data}{a data frame containg coordinates information of peaks
to be merged. Columns of the data frame should be consistent with
the BED format where the first column contains chromosome information,
the second column the starting position, and the third column 
the ending position.}

\item{dir}{a character string giving the directory where BED files
are stored. If \code{data} is not given, the function will reads
in the BED files under \code{code}.}

\item{pattern}{an \code{\link{regular expression}}, only files that
have names match the regular expression will be read in.}

\item{merge}{logical indicating whether to merge overlapped regions
or not. If False, regions are simply combined.}

\item{overlap}{a numberic value giving the least number of base(s)
two regions should overlap when merging them.}

\item{ratio}{a numberic value giving the thresold of overlapping
ratio between two regions to merge them. See '\code{Details}' below
for the definition of the overlapping ratio.}
}
\value{
a data frame with four columns: \code{chr}, \code{start},
\code{stop}, \code{id}
}
\description{
This function merges overlapping genomic regions into a single feature. 
The merged single feature represents the widest genomic interval 
that covers all overlapping regions.
}
\details{
The overlapping ratio (OR) is defined as:

\deqn{ OR = \frac{n}{\min(length(a), length(b)}}

\eqn{a}, \eqn{b} are two genomic regions, \eqn{n} is the number of
overlapping bases between region \eqn{a} and region \eqn{b}.
}
\examples{
peaks <- data.frame(chr = c(rep('chr1',4),rep('chr2', 3), rep('chr3',2)),
                    start = c(100,148,230,300,330,480,1000,700,801),
                    end = c(150,220,500,450,600,900,1050,760,900))

merged_peaks <- peakreference(data = peaks, merge = TRUE, overlap = 1)

}
\author{
Mengjun Wu, Lei Gu
}
