% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addTBsignature.R
\name{addTBsignature}
\alias{addTBsignature}
\title{Introduce a new signature into the TBSignatureProfiler.}
\usage{
addTBsignature(
  sigsymbols,
  authname,
  signame_common = NULL,
  sigtype,
  tissuetype,
  saveobjs = FALSE,
  views = TRUE
)
}
\arguments{
\item{sigsymbols}{a \code{character vector} of the gene symbols that compose
the signature to be added. Required.}

\item{authname}{a \code{character} string containing the last name of the primary
author of the publication where the signature was first identified.
If spaces are present, omit them, and use proper capitalization. Required.}

\item{signame_common}{a \code{character} string of the alternate name of the
signature given by the publication, if it exists. If \code{NULL}, no
assigned name is assumed to exist. Default is \code{null}.}

\item{sigtype}{a \code{character} string that gives the context that the
signature was developed under. Most commonly,
it will distinguish TB from LTBI ("Disease"),
TB from some combination of other diseases and possibly LTBI
("Disease/Other Diseases"), TB from Human Immunodeficiency Virus
("Disease/HIV"), TB from pneumonia ("Disease/Pneumonia"),
or identify risk of progression to TB ("risk"), risk of TB treatment
failure ("failure"), or classify treatment responses
(i.e., failures from cures, "response"). Required.}

\item{tissuetype}{a \code{character} string that denotes whether the
signature was developed using samples of either whole blood/paxgene
("whole blood") or peripheral blood mononuclear cells ("PBMC").
Due to the manipulation of cells inherently required to obtain PBMCs,
many scientists prefer to use only whole blood samples for analysis.
Accepts "whole blood", "PBMC" or "mixed". Required.}

\item{saveobjs}{\code{logical}. If \code{TRUE}, the contents of the data
file (\code{TBsignatures}, \code{TBcommon}, \code{sigAnnotData},
\code{common_sigAnnotData}) will be overwritten and updated to include
the new signature. If \code{FALSE}, no files will be overwritten, but
you can check function output for errors before writing RDS objects
by setting \code{views = TRUE}. Default is \code{saveobjs = FALSE}.}

\item{views}{logical. If \code{TRUE}, all objects will be sent to a
data view in a new window to check for errors. Default is \code{TRUE}.}
}
\value{
Either data objects \code{TBsignatures}, \code{TBcommon},
\code{sigAnnotData}, and \code{common_sigAnnotData} will be updated with the
new signature and overwritten if \code{saveobjs = FALSE}, or no output will
be produced except errors and messages for checking that the function
runs correctly given the inputs.
}
\description{
This function allows users to integrate new signatures into the TBSP
with a function that updates the TBsignatures, TBcommon,
sigAnnotData and common_sigAnnotData objects. Users that wish to use this
function should do so with the downloaded package as a working directory,
and not as a casual package function. This function does not complete all
required updates to the package for a signature to be full added; users
should check the vignette "Submitting Signatures to the TBSP Package"
on the
\href{https://wejlab.github.io/TBSignatureProfiler-docs/.}{TBSP website}
for a walkthrough of this complete process.
Also note that this function only adds one signature at a time,
and must me run multiple times to add subsequent signatures.
}
\examples{
# Mock example signature
TBSignatureProfiler:::addTBsignature(sigsymbols = c("GBP5", "BATF2", "GZMA"),
                            authname = "Odom",
                            signame_common = NULL,
                            sigtype = "Disease/HIV",
                            tissuetype = "PBMC",
                            saveobjs = FALSE,
                            views = FALSE)
}
