% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{Bootstrap_LOOCV_LR_AUC}
\alias{Bootstrap_LOOCV_LR_AUC}
\title{Bootstrap on Leave-one-out CV with Logistic Regression.}
\usage{
Bootstrap_LOOCV_LR_AUC(df, targetVec, nboot)
}
\arguments{
\item{df}{a \code{data.frame} of gene expression count data. Required.}

\item{targetVec}{a binary vector of the response variable. Should be
the same number of rows as \code{df}. Required.}

\item{nboot}{an integer specifying the number of bootstrap iterations.}
}
\value{
A list of length 2 with elements \item{auc}{A vector the length of
\code{nboot} with the AUC from each bootstrap iteration.}
\item{byClass}{A dataframe with number of rows equal to \code{nboot}. Each
row contains the sensitivity, specificity, positive predictive
value, negative predictive value, precision, recall, F1, prevalence,
detection rate, detection prevalence and balanced accuracy for that
bootstrap iteration.}
}
\description{
Bootstrap on Leave-one-out CV with Logistic Regression.
}
