% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon_mimic.R
\name{codon_mimic}
\alias{codon_mimic}
\alias{codon_mimic,regioned_dna,vector-method}
\alias{codon_mimic,regioned_dna,DNAStringSet-method}
\alias{codon_mimic,DNAStringSet,DNAStringSet-method}
\title{Mimic a target codon usage bias}
\usage{
codon_mimic(object, alt, numcode = 1, ...)

\S4method{codon_mimic}{regioned_dna,vector}(object, alt, numcode)

\S4method{codon_mimic}{regioned_dna,DNAStringSet}(object, alt, numcode)

\S4method{codon_mimic}{DNAStringSet,DNAStringSet}(object, alt, numcode)
}
\arguments{
\item{object}{regioned_dna object}

\item{alt}{target codon usage vector or DNAStringSet object representing
target codon usage}

\item{numcode}{The ncbi genetic code number for translation. Default value: \code{1}. Details please refer to \code{?seqinr::translate} ("https://rdrr.io/cran/seqinr/man/translate.html").}

\item{...}{...}
}
\value{
regioned_dna
}
\description{
Mutating the current DNA sequences in the regioned_dna object to mimic a
target codon usage pattern.
}
\details{
The ideas for \code{codon_mimic} is similar to
  \code{\link{codon_to}}: first extract the mutable regions and then do the
  mutation. However the codons in the fixed (not mutable) regions will also
  alter the final codon usage, thus we have to adjust for the fixed codons
  when introducing sysnonymous codons. The ideal deisgn for
  \code{codon_mimic} is not unique as the swap between positions of the
  synonymous codons will not change the codon usage bias.

  Details pleas refer to: https://koohoko.github.io/SynMut/algorithm.html
}
\examples{
filepath <- system.file("extdata", "example.fasta", package = "SynMut")
rgd.seq <- input_seq(filepath)
target <- get_cu(rgd.seq)[2,]
new <- codon_mimic(rgd.seq, alt = target)
get_cu(new) - get_cu(rgd.seq)

target <- Biostrings::DNAStringSet("TTGAAAA-CTC-N--AAG")
new <- codon_mimic(rgd.seq, alt = target)
get_cu(new) - get_cu(rgd.seq)
get_freq(new) - get_freq(rgd.seq)
get_rscu(new) - get_rscu(rgd.seq)
}
\seealso{
\code{\link{input_seq}}, \code{\link{codon_to}},
  \code{\link{codon_random}}, \code{\link{dinu_to}}
}
