% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_analysis.R
\name{codon_dist}
\alias{codon_dist}
\alias{codon_dist,ANY-method}
\title{Calculating the codon usage difference between sequences}
\usage{
codon_dist(seq, ref)

\S4method{codon_dist}{ANY}(seq, ref)
}
\arguments{
\item{seq}{the input DNA sequnece of \code{DNAStringSet} or
\code{regioned_dna} class.}

\item{ref}{the reference DNA sequnece of \code{DNAStringSet} or
\code{regioned_dna} class.}
}
\value{
vector
}
\description{
We use a least squares approach to estimate the codon usage
difference between DNA sequences.
}
\details{
idea inspired by "Daniel Macedo de Melo Jorge, Ryan E.
  Mills, Adam S. Lauring, CodonShuffle: a tool for generating and analyzing
  synonymously mutated sequences, Virus Evolution, Volume 1, Issue 1, March
  2015, vev012, https://doi.org/10.1093/ve/vev012"
}
\examples{
filepath <- system.file("extdata", "example.fasta", package = "SynMut")
rgd.seq <- input_seq(filepath)
get_cu(rgd.seq)

mut.seq <- codon_random(rgd.seq)
codon_dist(mut.seq, rgd.seq)
mut.seq2 <- codon_random(rgd.seq, keep = TRUE)
codon_dist(mut.seq2, rgd.seq)
}
